<?php
// En /saborgaucho.jobskm.com/login.php

// Inicia la sesión de PHP
session_start();

// 1. INCLUIR EL ARCHIVO DE CONFIGURACIÓN
// Asume que 'config.php' está en /includes/
require_once 'includes/config.php'; 

// 2. VARIABLES Y MENSAJES
$error_message = '';
$success_message = '';

// 3. PROCESAMIENTO DEL FORMULARIO
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $input_username = $_POST['username'] ?? '';
    $input_password = $_POST['password'] ?? '';

    if (empty($input_username) || empty($input_password)) {
        $error_message = "Por favor, ingrese un usuario y una contraseña.";
    } else {
        try {
            // Conexión PDO a MySQL usando CONSTANTES de config.php
            $dsn = "mysql:host=" . DB_SERVER . ";dbname=" . DB_NAME . ";charset=utf8";
            $conn = new PDO($dsn, DB_USER, DB_PASS);
            $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

            // Consulta preparada: Busca al empleado por nombre de usuario
            $stmt = $conn->prepare("SELECT password FROM " . EMPLOYEE_TABLE . " WHERE username = :username");
            $stmt->bindParam(':username', $input_username);
            $stmt->execute();
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            // 4. VERIFICACIÓN DE CREDENCIALES
            if ($user) {
                // VERIFICACIÓN SEGURA: Usa password_verify() para comparar el hash guardado con la contraseña ingresada
                if (password_verify($input_password, $user['password'])) {
                    
                    // Credenciales correctas: Establecer nivel de acceso para el chatbot
                    $_SESSION['user_level'] = 'empleado'; // Clave para el chatbot
                    $_SESSION['logged_in'] = true;
                    $_SESSION['username'] = $input_username;
                    
                    $success_message = "Inicio de sesión exitoso. Redirigiendo...";
                    
                    // Redirigir a la página principal del sitio web
                    header("Location: index.php");
                    exit(); 
                } else {
                    // Contraseña incorrecta
                    $error_message = "Usuario o contraseña incorrecta."; 
                }
            } else {
                // Usuario no encontrado
                $error_message = "Usuario o contraseña incorrecta.";
            }

        } catch (PDOException $e) {
            $error_message = "Error de conexión con la base de datos.";
            // Nota: Se recomienda registrar el error real ($e->getMessage()) en un log, no mostrarlo al usuario.
        }
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Acceso para Empleados</title>
    <style>
        /* CSS Simple para el formulario de login */
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
        .login-container { background: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); width: 300px; }
        .login-container h2 { text-align: center; margin-bottom: 20px; }
        .login-container input[type="text"], .login-container input[type="password"] { width: 100%; padding: 10px; margin-bottom: 15px; border: 1px solid #ccc; border-radius: 4px; box-sizing: border-box; }
        .login-container button { width: 100%; padding: 10px; background-color: #5cb85c; color: white; border: none; border-radius: 4px; cursor: pointer; }
        .login-container button:hover { background-color: #4cae4c; }
        .error { color: red; margin-bottom: 15px; text-align: center; }
        .success { color: green; margin-bottom: 15px; text-align: center; }
        .back-link { display: block; text-align: center; margin-top: 15px; color: #333; text-decoration: none; }
    </style>
</head>
<body>
    <div class="login-container">
        <h2>Acceso Empleados</h2>
        <?php 
        if ($error_message) {
            echo "<p class='error'>{$error_message}</p>";
        }
        if ($success_message) {
             echo "<p class='success'>{$success_message}</p>";
        }
        ?>
        <form method="POST" action="login.php">
            <input type="text" name="username" placeholder="Usuario" required>
            <input type="password" name="password" placeholder="Contraseña" required>
            <button type="submit">Ingresar</button>
        </form>
        <a href="index.php" class="back-link">Volver al inicio</a>
    </div>
</body>
</html>