document.addEventListener('DOMContentLoaded', function() {
    // Función para normalizar texto: elimina tildes y convierte a minúsculas
    function normalizeText(text) {
        return text.toLowerCase().normalize('NFD').replace(/[\u0300-\u036f]/g, "");
    }

    // Esta parte maneja el cuadro de búsqueda en el encabezado
    const searchBtn = document.querySelector('.search-btn');
    const searchInput = document.querySelector('.search-input');

    if (searchBtn && searchInput) {
        searchBtn.addEventListener('click', function() {
            const query = searchInput.value.trim();
            if (query) {
                window.location.href = `resultados-busqueda.php?query=${encodeURIComponent(query)}`;
            }
        });
        
        searchInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                searchBtn.click();
            }
        });
    }

    // Esta parte maneja la visualización de los resultados en la página de resultados
    const resultsContainer = document.getElementById('results-container');
    const urlParams = new URLSearchParams(window.location.search);
    const query = urlParams.get('query');

    if (resultsContainer && query) {
        // Enfoca el campo de búsqueda cuando la página de resultados se carga
        const headerSearchInput = document.querySelector('.search-input');
        if (headerSearchInput) {
            headerSearchInput.focus();
        }

        // Tu "base de datos" de páginas
        const pages = {
            /*'index.php': 'Página de inicio - Sabor Gaucho ofrece la mejor experiencia de churrasquería argentina en La Paz. Carnes a la parrilla, eventos especiales y un ambiente único para disfrutar con la familia y amigos.',
            'quienes-somos.php': 'Quiénes somos - Conoce nuestra historia y la pasión por la cocina argentina. El Sabor Gaucho fue fundado en 2010 y nos dedicamos a entregar la autentica experiencia gaucha en La Paz. Somos un equipo de profesionales apasionados por la carne y el servicio.',
            'restaurante.php': 'Nuestro restaurante - Descubre nuestros espacios, la decoración rústica, y la atmósfera ideal para disfrutar de la carne. Ofrecemos una variedad de cortes de res, cerdo y pollo, además de guarniciones típicas y una amplia carta de vinos.',
            'eventos.php': 'Eventos - Organiza tu evento especial con nosotros. Ofrecemos paquetes para cumpleaños, bodas, y eventos corporativos. Contamos con salones privados, un servicio personalizado y un menú adaptado a tus necesidades.',
            'contactanos.php': 'Contáctanos - Encuentra nuestra dirección, números de teléfono y formulario de contacto para reservas. Estamos ubicados en el corazón de La Paz, listos para atenderte y ofrecerte la mejor experiencia culinaria.',*/
            'index.php': '<b>Página de inicio</b> - <br>Sabor Gaucho le ofrece la mejor experiencia de la Churrasquería Argentina en las ciudades de La Paz y El Alto.<br>Exquisitas carnes a la parrilla, vinos, postres y música en vivo; para compartir esos momentos inolvidables o eventos especiales en un ambiente único y acogedor, donde podrá disfrutar con la familia, amigos o colegas de trabajo.',
            'quienes-somos.php': '<b>Quiénes somos</b> - <br>Conoce nuestra historia y la pasión por la cocina argentina.<br>Nuestra trayectoria y experiencia, con más de 25 años, nos posiciona como un equipo de profesionales apasionados por la carne asada y la entrega de un servicio cálido, cordial y ameno a los más privilegiados que son, nuestros clientes.',
            'restaurante.php': '<b>Servicio de Restaurante</b> - <br>Ofrecemos una variedad de carnes asadas en diferentes cortes, además de guarniciones típicas, una amplia carta de vinos y sabrosos postres o entremeses.<br>Nuestro servicio personalizado y el menú adaptado a las necesidades de nuestra clientela, permite que cada temporada ofrezcamos las novedades en paquetes para cumpleaños, bodas, eventos corporativos (Reuniones de Trabajo) o encuentro de amigos.<br>También ponemos a su disposición el servicio de Atención de Catering y Delivery (pedidos por internet), para llevar nuestro exquisito sazón al alcance de sus eventos en los ambientes de su elección o directamente a su domicilio.',
            'eventos.php': '<b>Atención de Eventos</b> - <br>Organice sus eventos especiales con nosotros, contamos con salones privados o compartidos y; ambientes abiertos, puestos a la disposición de nuestros clientes en: Sopocachi, Obrajes, San Jorge y El Alto, cada uno de ellos garantizando la comodidad, calidez y confidencialidad requerida.<br>Descubra en nuestros espacios, la decoración rústica y la atmósfera ideal para disfrutar de una variedad de cortes de carne, junto a las guarniciones típicas y una amplia carta de vinos.',
            'contactanos.php': '<b>Contáctanos</b> - <br>Encuentre nuestras direcciones, números de teléfono y contactos para reservas.<br><b>Nuesrta ubicación:</b> Estamos ubicados en las ciudades de La Paz y El Alto, listos para atender y ofrecer la mejor experiencia culinaria.',
        };

        const foundResults = [];
        const normalizedQuery = normalizeText(query);

        for (const page in pages) {
            const content = normalizeText(pages[page]);
            // Modificamos la lógica para buscar la palabra de manera más flexible
            if (content.includes(normalizedQuery)) {
                foundResults.push({
                    title: pages[page].split(' - ')[0],
                    url: page,
                    snippet: pages[page]
                });
            }
        }

        if (foundResults.length > 0) {
            resultsContainer.innerHTML = ''; // Limpia los resultados previos si los hay
            foundResults.forEach(result => {
                const resultItem = document.createElement('div');
                resultItem.classList.add('result-item');
                resultItem.innerHTML = `
                    <p>${result.snippet}</p>
                    <h3 class="result-url"><a href="${result.url}">${result.title}</a></h3>
                `;
                resultsContainer.appendChild(resultItem);
            });
        } else {
            resultsContainer.innerHTML = `<p>No se encontraron resultados para "${query}".</p>`;
        }
    }
});