// AÑADIDO: Lógica para el botón flotante (Toggle)
const chatContainer = document.getElementById('chat-container');
const chatToggleButton = document.getElementById('chat-toggle-btn');

if (chatToggleButton) {
    chatToggleButton.addEventListener('click', function() {
        if (chatContainer.style.display === 'none' || chatContainer.style.display === '') {
            // Mostrar chat
            chatContainer.style.display = 'flex';
            this.innerHTML = '<i class="fas fa-times"></i> Cerrar'; // Cambiar a ícono de cerrar
        } else {
            // Ocultar chat
            chatContainer.style.display = 'none';
            this.innerHTML = '<i class="fas fa-comment-dots"></i> Chatbot'; // Restaurar ícono de chat
        }
    });
}
// ------------------------------------------------------------------------------------------------------


const chatLog = document.getElementById('chat-log');
const userInput = document.getElementById('user-input');
const sendButton = document.getElementById('send-button');

sendButton.addEventListener('click', sendMessage);

userInput.addEventListener('keypress', function(event) {
    if (event.key === 'Enter') {
        sendMessage();
    }
});

function sendMessage() {
    const message = userInput.value;
    if (message.trim() !== '') {
        displayUserMessage(message);
        userInput.value = '';
        fetchResponse(message);
    }
}

function displayUserMessage(message) {
    displayMessage(message, 'user');
}

function displayBotMessage(message, options = []) {
    let fullMessage = message;
    if (options.length > 0) {
        fullMessage += '<div class="response-options">';

        options.forEach(option => {
            const optionJsonString = JSON.stringify(option).replace(/'/g, "\\'");
            fullMessage += `<button class="response-button" onclick="handleOptionClick(JSON.parse(decodeURIComponent('${encodeURIComponent(optionJsonString)}')))">${option.valor}</button>`;

        });
        fullMessage += '</div>';
    }
    displayMessage(fullMessage, 'bot');
}

function fetchResponse(message) {
    const timestamp = new Date().getTime();
    // Asegúrate que el endpoint es correcto
    const url = `obtener_respuesta.php?_t=${timestamp}`;

    fetch(url, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: `pregunta=${encodeURIComponent(message)}`
    })
    .then(response => {
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        return response.json();
    })
    .then(data => {
        displayBotMessage(data.respuesta, data.opciones);
    })
    .catch(error => {
        console.error('Fetch error:', error);
        displayBotMessage('Lo siento, hubo un error al conectar con el servidor. Por favor, intenta de nuevo más tarde.');
    });
}

function handleOptionClick(option) {
    console.log("Opción clicada (DEBUG):", option);

    if (option.tipo === 'url') {
        window.open(option.valor, '_blank');
    } else if (option.tipo === 'cerrar') {
        displayBotMessage(`¡Gracias por contactar con SakeMaBot! Estaremos encantados de ayudarte de nuevo.`);

        setTimeout(() => {
            const chatContainer = document.getElementById('chat-container');
            if (chatContainer) {
                // Modificado para usar la lógica del toggle
                chatContainer.style.display = 'none';
                chatToggleButton.innerHTML = '<i class="fas fa-comment-dots"></i> Chatbot'; 
            }
            document.getElementById('chat-log').innerHTML = '';
            userInput.value = '';
        }, 2000);

    } else {
        userInput.value = option.valor; 
        sendMessage(); 
    }
}

window.onload = function() {
    // Para no iniciar la conversación inmediatamente al cargar, 
    // lo haremos solo cuando se abra el chat la primera vez o si lo deseas
    // fetchResponse('hola');
    userInput.focus();
};

function displayMessage(message, sender) {
    const messageContainer = document.createElement('div');
    messageContainer.classList.add('message-container');
    messageContainer.classList.add(`${sender}-message`);

    let avatar = '';
    if (sender === 'bot') {
        avatar = '<img src="images/bot_avatar.png" alt="Bot Avatar" class="bot-avatar">';
    }

    const messageText = `<div class="message-text">${message}</div>`;
    
    if (sender === 'bot') {
        messageContainer.innerHTML = avatar + messageText;
    } else {
        messageContainer.innerHTML = messageText;
    }
    
    chatLog.appendChild(messageContainer);
    chatLog.scrollTop = chatLog.scrollHeight;
}