document.addEventListener('DOMContentLoaded', () => {
    // Lógica para el banner de texto dinámico
    const textSlides = document.querySelectorAll('.banner-slider .slide');
    let currentTextSlide = 0;

    function showTextSlide(index) {
        textSlides.forEach((slide, i) => {
            if (i === index) {
                slide.classList.add('active');
            } else {
                slide.classList.remove('active');
            }
        });
    }

    function nextTextSlide() {
        currentTextSlide = (currentTextSlide + 1) % textSlides.length;
        showTextSlide(currentTextSlide);
    }

    showTextSlide(currentTextSlide);
    setInterval(nextTextSlide, 3000); // Cambia el texto cada 3 segundos

    // Aquí debes colocar el código que te di
    document.querySelectorAll('.tarjeta').forEach(tarjeta => {
        tarjeta.addEventListener('click', () => {
            const url = tarjeta.getAttribute('data-url');
            if (url) {
                // Abre el enlace en una nueva pestaña
                window.open(url, '_blank'); 
            }
        });
    });
});