<?php
// PHP simple para manejar el envío y llamar al script principal
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Si se envió el formulario, redirigimos los datos a la API original
    $api_url = 'api_movimiento.php'; // Cambia a api_sincronizador.php si quieres probar la sincronización

    // Aquí simplemente incluimos el archivo para que use los datos POST
    // Esto es un atajo para el debug, el código real de la API debe estar en su archivo.
    
    // Al incluir, api_movimiento.php intentará procesar el $_POST que enviamos abajo
    include($api_url); 
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Prueba de Carga Manual API</title>
    <style>body {font-family: Arial; padding: 20px;} input, select {margin-bottom: 10px; padding: 8px; width: 100%; box-sizing: border-box;}</style>
</head>
<body>
    <h2>Simulación de Envío de App Inventor</h2>
    <form method="POST" action="form_prueba.php">
        <label for="qr">Código QR:</label>
        <input type="text" id="qr" name="qr" value="TEST-QR-MANUAL" required>
        
        <label for="ci">CI Usuario:</label>
        <input type="text" id="ci" name="ci" value="987654" required>
        
        <label for="proceso">Proceso:</label>
        <select id="proceso" name="proceso" required>
            <option value="ENTRADA">ENTRADA</option>
            <option value="SALIDA">SALIDA</option>
        </select>

        <label for="sucursal_origen">Origen:</label>
        <input type="text" id="sucursal_origen" name="sucursal_origen" value="MANUAL-ORIGEN">

        <label for="sucursal_destino">Destino:</label>
        <input type="text" id="sucursal_destino" name="sucursal_destino" value="MANUAL-DESTINO">

        <label for="descripcion">Descripción (opcional):</label>
        <input type="text" id="descripcion" name="descripcion" value="Prueba desde formulario web">
        
        <button type="submit" style="background-color: green; color: white; padding: 10px;">ENVIAR A API_MOVIMIENTO.PHP</button>
    </form>
</body>
</html>