<?php
header('Content-Type: application/json');
// Incluye tu conexión segura
require_once __DIR__ . '/includes/config.php'; 

try {
    // ESTA ES LA ÚNICA LÍNEA DE CÓDIGO CRÍTICA QUE SE EJECUTARÁ
    $dsn = "mysql:host=" . DB_SERVER . ";dbname=" . NOMBRE_DB . ";charset=utf8mb4";
    $pdo = new PDO($dsn, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // ÉXITO: Si llegamos aquí, la conexión es PERFECTA.
    echo json_encode(array("status" => "DEBUG", "mensaje" => "Conexion PDO Finalizada sin ERRORES de CRASHEO."));
    exit(); 
    
} catch (Exception $e) {
    // Si la conexión falla, se devuelve un JSON de error
    http_response_code(500);
    echo json_encode(array("status" => "error", "mensaje" => "Error de BD: " . $e->getMessage()));
    exit();
}
?>